#include <windows.h>
#include <stdio.h>

void ShowErrorMessage()
{
  char* lpMsgBuf;
  FormatMessage( 
    FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
    NULL,
    GetLastError(),
    MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), 
    (LPTSTR) &lpMsgBuf,
    0,
    NULL 
    );

  // Poka komunikat
  MessageBox( NULL, lpMsgBuf, "GetLastError", MB_OK|MB_ICONINFORMATION );

  // Zwolnij pami
  LocalFree( lpMsgBuf );

  exit( 1 );
}

int main( int argc, char **argv )
{
  BOOL bResult;

  const int nBytesToRead = 512;
  unsigned long nBytesRead;
  unsigned long nBytesWrote;
  char  inBuffer[nBytesToRead];

  HANDLE hFloppy = CreateFile( "\\\\.\\a:", 
      GENERIC_WRITE | GENERIC_READ, 
      FILE_SHARE_READ | FILE_SHARE_WRITE,
      NULL, OPEN_EXISTING, 0, NULL );
  if ( hFloppy == INVALID_HANDLE_VALUE ) ShowErrorMessage();

  HANDLE hData = CreateFile( "read.bin", 
       GENERIC_READ | GENERIC_WRITE, 
       FILE_SHARE_READ | FILE_SHARE_WRITE,
       NULL, CREATE_ALWAYS, 0, NULL );  
  if ( hData == INVALID_HANDLE_VALUE ) ShowErrorMessage();

  // kopiuj obraz dyskietki do pliku
  do
  {
    bResult = ReadFile( hFloppy, &inBuffer, nBytesToRead, &nBytesRead, NULL) ; 
    if ( bResult )
      WriteFile( hData, inBuffer, nBytesRead, &nBytesWrote, NULL );
  } while ( bResult != 0 && nBytesRead > 0 );

  CloseHandle( hFloppy );
  CloseHandle( hData );

  return 0;
}
